const React = require('react');
const ReactDOM = require('react-dom');

const SingleTaskCommonView = require('../singleTask/SingleTaskCommonView');
const SingleTaskDescriptionView = require('../singleTask/SingleTaskDescriptionView');
const SingleTaskCommonCustomFieldsView = require('../singleTask/customProps/SingleTaskCommonCustomFieldsView');
const SingleTaskCommonCustomOutputFieldsView =
    require('../singleTask/customProps/SingleTaskCommonCustomOutputFieldsView');
const HostsInfo = require('../../components/HostsInfo');
const AdvancedInfo = require('../../components/AdvancedInfo');
const SemaphoreInfo = require('../../components/SemaphoreInfo');
const ClientTagsInfo = require('../../components/ClientTagsInfo');
const NotificationInfo = require('../../components/NotificationInfo');
const OwnerInfo = require('../../components/OwnerInfo');

/**
 * @class SingleSchedulerCommonView
 * @extends SingleTaskCommonView
 *
 * @property {SchedulerModel} model
 * @property {Marionette.Region} hostsInfo
 * @property {Marionette.Region} notification
 * @property {Marionette.Region} customFields
 * @property {Marionette.Region} customOutputFields
 * @property {Marionette.Region} advancedAsideInfo
 */
const SingleSchedulerCommonView = SingleTaskCommonView.extend({

    className: 'section__side__i',
    template: require('./tpl/compact/SingleSchedulerCommonView.hbs'),

    ui: {
        advancedAsideInfo: '#advancedAsideInfo',
        semaphoresAsideInfo: '#semaphoresAsideInfo',
        notificationAsideInfo: '#notificationAsideInfo',
        clientTagsInfo: '#clientTagsInfo',
        hostsInfo: '#hostsInfo',
        ownerAsideInfo: '#owner-info'
    },

    onRender() {
        this.description.close();
        this.description.show(new SingleTaskDescriptionView({
            model: this.model.getTask()
        }));

        this.customFields.close();
        this.customFields.show(new SingleTaskCommonCustomFieldsView({
            model: this.model.getTask(),
            taskProps: this.options.taskProps
        }));

        this.customOutputFields.close();
        this.customOutputFields.show(new SingleTaskCommonCustomOutputFieldsView({
            model: this.model.getTask(),
            taskProps: this.options.taskProps
        }));

        if (this.ui.ownerAsideInfo[0]) {
            ReactDOM.render(
                <OwnerInfo owner={this.model.get('owner')} namespace={'schedulers'}/>,
                this.ui.ownerAsideInfo[0]
            );
        }

        if (this.ui.hostsInfo[0]) {
            ReactDOM.render(
                <HostsInfo model={this.model.getTask()}/>,
                this.ui.hostsInfo[0]
            );
        }

        if (this.ui.advancedAsideInfo[0]) {
            ReactDOM.render(
                <AdvancedInfo model={this.model.getTask()}/>,
                this.ui.advancedAsideInfo[0]
            );
        }

        if (this.ui.clientTagsInfo[0]) {
            ReactDOM.render(
                <ClientTagsInfo model={this.model.getTask()}/>,
                this.ui.clientTagsInfo[0]
            );
        }

        if (this.ui.semaphoresAsideInfo[0]) {
            ReactDOM.render(
                <SemaphoreInfo model={this.model.getTask()}/>,
                this.ui.semaphoresAsideInfo[0]
            );
        }

        if (this.ui.notificationAsideInfo[0]) {
            ReactDOM.render(
                <NotificationInfo model={new Backbone.Model({ notifications: this.model.task.get('notifications') })}/>,
                this.ui.notificationAsideInfo[0]
            );
        }
    },

    serializeData() {
        return this.model.serialize();
    },

    renderRefreshableData() {

        // Nothing to rerender
    }
});

module.exports = SingleSchedulerCommonView;
