const app = require('../../app');
const CreateSchedulerLayout = require('../createScheduler/CreateSchedulerLayout');
const SingleSchedulerCommonView = require('./SingleSchedulerCommonView');

/**
 * @class SingleSchedulerCommonViewFactory
 */
const SingleSchedulerCommonViewFactory = {

    factory(options) {
        const scheduler = app.request('DRAFT_SCHEDULER');

        if (scheduler) {
            return new CreateSchedulerLayout({
                taskProps: options.app.getProps(),
                model: options.model,
                user: options.app.get('user')
            });
        }
        return new SingleSchedulerCommonView(options);
    }
};

module.exports = SingleSchedulerCommonViewFactory;
