const SingleTaskEditView = require('./SingleTaskEditView');
const SingleTaskCommonView = require('./SingleTaskCommonView');

/**
 * @class SingleTaskCommonViewFactory
 */
const SingleTaskCommonViewFactory = {

    factory(options) {
        if (options.model.canBeEdited()) {
            return new SingleTaskEditView({
                taskProps: options.app.getProps(),
                model: options.model,
                user: options.app.get('user')
            });
        }
        return new SingleTaskCommonView(options);
    }
};

module.exports = SingleTaskCommonViewFactory;
