const BasicTaskLayout = require('../tasks/tasksGrid/row/BasicTaskLayout');

/**
 * @class SingleTaskContextView
 * @extends BasicTaskLayout
 */
const SingleTaskContextView = BasicTaskLayout.extend({

    className: 'section__i section__i_t',
    template: require('./tpl/SingleTaskContextView.hbs'),

    serializeData() {
        const context = this.serializeContext();

        const contextItemsSdk1 = _.filter(context, { isInputParam: true });
        const contextItemsSdk2 = this.model.get('customFields') ?
            this.model.get('customFields').map(field => {
                return {
                    key: field.name,
                    value: _.isArray(field.value) || _.isObject(field.value) ?
                        JSON.stringify(field.value) :
                        field.value,
                    isInputParam: true
                };
            }) : [];

        return {
            inputParams: Number(this.model.get('sdk_version')) === 1 ?
                contextItemsSdk1 :
                contextItemsSdk2,
            other: _.filter(context, { isInputParam: false })
        };
    }
});

module.exports = SingleTaskContextView;
