/**
 * @class SingleTaskCopiedFrom
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const SingleTaskCopiedFrom = Marionette.ItemView.extend({

    template: require('./tpl/SingleTaskCopiedFrom.hbs'),

    tagName: 'tr',

    options: {
        loading: true
    },

    initialize() {
        this._model = this.model.clone();

        this._model.fetchContext().done(() => {
            this.options.loading = false;
            this.render();
        });
    },

    getCopySourceId() {
        /* eslint camelcase: 0 */
        const context = this._model.get('context');

        return (context ? context.copy_of : false);
    },

    serializeData() {
        return {
            loading: this.options.loading,
            copy_of: this.getCopySourceId()
        };
    }
});

module.exports = SingleTaskCopiedFrom;
