const TaskFooterBuilder = require('../../helpers/api/TaskFooterBuilder');

/**
 * @class SingleTaskCustomFooterView
 * @extends Backbone.Marionette.ItemView
 *
 * @property {TaskMode} model
 */
const SingleTaskCustomFooterView = Marionette.ItemView.extend({

    className: 'section__side__r custom_footer_cnt',
    id: 'custom-footer',

    template: require('./tpl/SingleTaskCustomFooterView.hbs'),

    options: {
        ready: false
    },

    initialize(options) {
        const self = this;

        this.options = _.extend({}, this.options, options);

        this.model
            .fetchReport('footer')
            .done(() => {
                if (!self.model.get('footer')) {
                    self.$el.hide();

                    return;
                }

                const footerContent = (new TaskFooterBuilder({
                    data: self.model.get('footer').processedData
                })).buildFooters();

                if (footerContent.length) {
                    self.setFooterContent(footerContent);
                    self.setReady(true);
                    self.render();
                } else {
                    self.$el.hide();
                }
            })
            .fail(xhr => {
                let errProps = {};

                if (xhr && xhr.status && xhr.status === 500 && xhr.responseText) {
                    try {
                        errProps = JSON.parse(xhr.responseText);
                    } catch (excpt) {
                        errProps = {
                            reason: 'Internal server error.'
                        };
                    }
                }

                self.renderWithError('Error during attempt to get footer\'s data', errProps);
            });
    },

    renderWithError(errorTitle, props) {
        this.options.error = _.extend({
            msg: errorTitle
        }, props);

        this.render();
    },

    setFooterContent(footerContent) {
        this.options.footerContent = footerContent;
    },

    setReady(isReady) {
        this.options.ready = Boolean(isReady);
    },

    serializeData() {
        return _.clone(this.options);
    }
});

module.exports = SingleTaskCustomFooterView;
