const TaskFooterBuilder = require('../../helpers/api/TaskFooterBuilder');

/**
 * @class SingleTaskCustomHeaderView
 * @extends Backbone.Marionette.ItemView
 *
 * @property {TaskMode} model
 */
const SingleTaskCustomHeaderView = Marionette.ItemView.extend({

    className: 'custom_header_cnt',
    id: 'custom-header',

    template: require('./tpl/SingleTaskCustomHeaderView.hbs'),

    options: {
        ready: false
    },

    initialize(options) {
        const self = this;

        this.options = _.extend({}, this.options, options);

        this.model
            .fetchReport('header')
            .done(() => {
                if (!self.model.get('header')) {
                    self.$el.hide();

                    return;
                }

                const footerContent = (new TaskFooterBuilder({
                    data: self.model.get('header').processedData
                })).buildFooters();

                if (footerContent.length) {
                    self.setFooterContent(footerContent);
                    self.setReady(true);
                    self.render();
                } else {
                    self.$el.hide();
                }
            })
            .fail(xhr => {
                let errProps = {};

                if (xhr && xhr.status && xhr.status === 500 && xhr.responseText) {
                    try {
                        errProps = JSON.parse(xhr.responseText);
                    } catch (excpt) {
                        errProps = {
                            reason: 'Internal server error.'
                        };
                    }
                }

                self.renderWithError('Error during attempt to get header\'s data', errProps);
            });
    },

    renderWithError(errorTitle, props) {
        this.options.error = _.extend({
            msg: errorTitle
        }, props);

        this.render();
    },

    setFooterContent(footerContent) {
        this.options.footerContent = footerContent;
    },

    setReady(isReady) {
        this.options.ready = Boolean(isReady);
    },

    serializeData() {
        return _.clone(this.options);
    }
});

module.exports = SingleTaskCustomHeaderView;
