// eslint-disable-next-line no-unused-vars
const Timer = require('../../helpers/utils/Timer.js');
const singleTaskGraphics = require('./tpl/SingleTaskGraphics.hbs');

/**
 * @class SingleTaskGraphicsRowView
 * @extends Marionette.ItemView
 */
const SingleTaskGraphicsRowView = Marionette.ItemView.extend({

    tagName: 'tr',
    template: require('./tpl/SingleTaskGraphicsRowView.hbs'),

    ui: {
        chartToggler: '.cpu_graph_toggler',
        chartColumn: '.c_cpu_graph',
        chartCnt: '.c_cpu_graph__cnt'
    },

    options: {
        compactClassName: 'c_cpu_graph_min'
    },

    events: {
        'click @ui.chartToggler': 'onChartsToggle'
    },

    onChartsToggle(eventObj) {
        eventObj.preventDefault();

        if (!this.ui.chartCnt.find('iframe').length) {
            this.ui.chartCnt.html(singleTaskGraphics({
                host: this.model.get('host'),
                from: this.model.get('from'),
                till: this.model.get('till'),
                last: this.model.get('last'),
                partition: this.model.get('partition')
            }));
        }

        this.ui.chartColumn.toggleClass(this.options.compactClassName);
    }
});

module.exports = SingleTaskGraphicsRowView;
