const Timer = require('../../helpers/utils/Timer.js');
// eslint-disable-next-line no-unused-vars
const BasicTaskLayout = require('../tasks/tasksGrid/row/BasicTaskLayout');

/**
 * @class SingleTaskGraphicsView
 * @extends Marionette.CompositeView
 */
const SingleTaskGraphicsView = Marionette.CompositeView.extend({

    className: 'section__i',
    template: require('./tpl/SingleTaskGraphicsView.hbs'),

    itemViewContainer: 'tbody',
    itemView: require('./SingleTaskGraphicsRowView.js'),

    initialize() {
        this.collection = new Backbone.Collection(this.model.get('relatedHosts').map(hostInfo => {
            const hostName = hostInfo.host.split('.');

            return {
                fqdn: hostInfo.host,
                host: hostName.length ? hostName[0] : '',
                from: hostInfo.from,
                till: hostInfo.till,
                partition: (hostInfo.partition ? hostInfo.partition : ''),
                formattedFrom: Timer.serializeTimeMark(Timer.toLocal(hostInfo.from)),
                formattedTill: Timer.serializeTimeMark(Timer.toLocal(hostInfo.till))
            };
        }));

        if (this.collection.length) {
            const model = this.collection.at(this.collection.length - 1);

            model.set('last', true);
        }
    }
});

module.exports = SingleTaskGraphicsView;
