const BasicTaskLayout = require('../tasks/tasksGrid/row/BasicTaskLayout');
const SingleTaskHistoryItemsView = require('./SingleTaskHistoryItemsView');

/**
 * @class SingleTaskHistoryView
 * @extends BasicTaskLayout
 *
 * @property {TaskModel} model
 */
const SingleTaskHistoryView = BasicTaskLayout.extend({

    className: 'section__i',
    template: require('./tpl/SingleTaskHistoryView.hbs'),

    ui: {
        timeFormatSwitcher: '.btn_format_switcher'
    },

    modelEvents: {
        'change:audit': 'render'
    },

    events: {
        'click @ui.timeFormatSwitcher': 'onTimeFormatChange'
    },

    getDefaultFormat() {
        return (window.localStorage &&
            window.localStorage.getItem &&
            window.localStorage.getItem('SINGLETASK_HISTORY_FORMAT') !== '1' &&
            window.localStorage.getItem('SINGLETASK_HISTORY_FORMAT')) ||
            SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_CREATE;
    },

    onRender() {
        /* eslint complexity: [1, 7] */

        this.$('.button').bemmyButton();
        this.history.close();
        this.history.show(this.getTaskHistoryItemsView());

        const format = parseInt(this.getDefaultFormat(), 10) || false;

        if (
            format &&
            (format === SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_CREATE ||
            format === SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_NOW ||
            format === SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_PREVIOUS)
        ) {
            this.model.get('audit').trigger('format:timing', format);
        }
    },

    onTimeFormatChange(evtObj) {
        const format = parseInt(evtObj.currentTarget.dataset.format, 10);

        evtObj.preventDefault();

        this.model.get('audit').trigger('format:timing', format);

        if (window.localStorage && window.localStorage.setItem) {
            window.localStorage.setItem('SINGLETASK_HISTORY_FORMAT', format);
        }
    },

    getTaskHistoryItemsView() {
        return new SingleTaskHistoryItemsView({
            collection: this.model.get('audit'),
            isAdmin: this.options.app.get('user').isAdmin()
        });
    },

    serializeData() {
        return {
            relative: SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_CREATE,
            nowRelative: SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_NOW,
            prevRelative: SingleTaskHistoryItemsView.TIME_FORMATTING.RELATIVE_TO_PREVIOUS,
            activeItem: this.getDefaultFormat()
        };
    }
});

module.exports = SingleTaskHistoryView;
