/* eslint camelcase: 0 */

const NotificationRecipientSuggestView = require('../createTask/NotificationRecipientSuggestView');
const NotificationModel = require('../../model/NotificationModel');
const BasicConfirmDialogView = require('../components/BasicConfirmDialogView');
const notification = require('../../notification');
const error = require('../../error');
// eslint-disable-next-line no-unused-vars
const app = require('../../app');

/**
 * @class SingleTaskReleaseModalView
 * @extends BasicConfirmDialogView
 *
 * @property {TaskModel}         model
 * @property {Marionette.Region} cc
 * @property {NotificationModel} ccModel
 */
const SingleTaskReleaseModalView = BasicConfirmDialogView.extend({

    template: require('./tpl/SingleTaskReleaseModalView.hbs'),

    ui: {
        subjectLabel: '.subject_label select',
        subjectTitle: '.subject_title input',
        changelog: '.changelog textarea',
        cc: '.cc',
        approve: '.app_modal_approve'
    },

    events: {
        approve: 'onApprove'
    },

    initialize(options) {
        BasicConfirmDialogView.prototype.initialize.apply(this, arguments);

        this.options = _.extend({}, this.options, options, { loadbutton: 'button_load' });
    },

    onRender() {
        this.$('.select').bemmySelect();
        this.$('.input').bemmyInput();
        this.$('.textarea').bemmyTextarea();

        this.ccModel = new NotificationModel({ recipients: this.serializeReceivers() });
        this.cc.close();
        this.cc.show(new NotificationRecipientSuggestView({
            fetchMailingLists: true,
            ownerGroups: this.options.ownerGroups,
            model: this.ccModel
        }));
    },

    gatherSubmitInfo() {
        return {
            cc: this.ccModel.get('recipients'),
            type: this.ui.subjectLabel.val(),
            task_id: this.model.get('id'),
            subject: this.ui.subjectTitle.val(),
            message: this.ui.changelog.val()
        };
    },

    onApprove() {
        const self = this;
        const taskID = this.model.get('id');

        self.ui.approve.addClass(this.options.loadbutton);

        return $.ajax({
            url: '/api/v1.0/release/',
            type: 'POST',
            data: JSON.stringify(this.gatherSubmitInfo()),
            dataType: 'json',
            contentType: 'application/json'
        }).always(() => {
            self.ui.approve.removeClass(this.options.loadbutton);
            self.close();
        }).done(() => {
            notification.message('Task #' + taskID + ' is going to release', { reload: false });
            self.model.fetch({ reset: true });

            Backbone.trigger('favicon:activate');
        }).fail(error.fromXHR);
    },

    serializeReceivers() {
        const releaseInfo = this.model.get('release');
        let receivers = [];

        if (releaseInfo && releaseInfo.template && releaseInfo.template.cc) {
            receivers = releaseInfo.template.cc;
        }

        return receivers;
    },

    serializeData() {
        const releaseInfo = this.model.get('release');
        const serialized = {};

        if (releaseInfo && releaseInfo.template) {
            serialized.types = releaseInfo.template.types;
            serialized.subject = releaseInfo.template.subject;
            serialized.message = releaseInfo.template.message;
        }

        return serialized;
    }
});

module.exports = SingleTaskReleaseModalView;
