import clipboardClientMixin from '../../views/components/clipboardClient/ClipboardClientMixin';

/**
 * @class SingleTaskReleasedResources
 * @extends Backbone.Marionette.ItemView
 *
 * @property {TaskModel} model
 * @property {TaskResourcesCollection} collection
 */
const SingleTaskReleasedResources = Marionette.ItemView.extend({

    tagName: 'table',
    className: 't t_max',

    template: require('./tpl/SingleTaskReleasedResources.hbs'),

    collectionEvents: {
        sync: 'render'
    },

    initialize() {
        this.collection.fetchExistingResources();
    },

    onRender() {
        clipboardClientMixin.initializeClipboardClient(
            '.skynet-proxy-copier',
            'Skynet copier link has been copied to clipboard.'
        );
    },

    serializeData() {
        return {
            status: this.model.get('status'),
            resources: this.collection.toJSON()
        };
    }
});

module.exports = SingleTaskReleasedResources;
