const BasicCollection = require('../../collection/BasicCollection');
const SingleTaskResourcesGridView = require('../tasks/taskResourcesGrid/SingleTaskResourcesGridView');

/**
 * @class SingleTaskResourcesView
 * @extends Marionette.Layout
 */
const SingleTaskResourcesView = Marionette.Layout.extend({

    className: 'section__i',
    template: require('./tpl/SingleTaskSubsView.hbs'),

    onRender() {
        this.subTable.close();
        this.subTable.show(new SingleTaskResourcesGridView({
            model: new Backbone.Model({}),
            collection: this.collection,
            selectable: false,
            sortType: BasicCollection.SORT_TYPE.CLIENT
        }));
    }
});

module.exports = SingleTaskResourcesView;
