const SingleTaskSideNavView = Marionette.ItemView.extend({

    className: 'side-nav',
    template: require('./tpl/SingleTaskSideNavView.hbs'),

    ui: {
        navItems: '.side-nav__list__i a'
    },

    events: {
        'click @ui.navItems': 'onNav'
    },

    options: {
        fixedClass: 'side-nav_fixed'
    },

    initialize(options) {
        this.sourceCnt = options.sourceCnt || $();
        this.appContainer = $(window);
        this.onBodyScroll = this.onBodyScroll.bind(this);

        this.collectNavItems();
        this.listenTo(this.appContainer, 'scroll', this.onBodyScroll);
    },

    onRender() {
        const self = this;

        setTimeout(() => {
            self.offsetTop = self.$el.offset().top;
        }, 0);
    },

    collectNavItems() {
        const self = this;

        self.items = [];

        this.sourceCnt.find('.nav-item').each((index, elt) => {
            self.items.push({
                title: elt.dataset.title,
                path: elt.getAttribute('id')
            });
        });
    },

    serializeData() {
        return {
            items: this.items
        };
    },

    onNav(evtObj) {
        evtObj.preventDefault();

        $('body').animate({
            scrollTop: this.sourceCnt.find('#' + evtObj.target.dataset.nav).offset().top + 'px'
        });
    },

    onBodyScroll() {
        if (this.appContainer.scrollTop() > this.offsetTop - 19) {
            this.$el.addClass(this.options.fixedClass);
        } else {
            this.$el.removeClass(this.options.fixedClass);
        }
    },

    onClose() {
        this.stopListening(this.appContainer, 'scroll');
    }
});

module.exports = SingleTaskSideNavView;
