const BasicCollection = require('../../collection/BasicCollection');
const TasksCompactGridView = require('../tasks/tasksGridCompact/grid/TasksCompactGridView');

const SingleTaskDependantView = Marionette.Layout.extend({

    className: 'section__i',
    template: require('./tpl/SingleTaskSubsView.hbs'),

    modelEvents: {
        'change:children': 'render'
    },

    onRender() {
        this.subTable.close();
        this.subTable.show(new TasksCompactGridView({
            model: this.model,
            collection: this.collection,
            selectable: this.options.selectable,
            expandable: true,
            unfilterable: true,
            sortable: false,
            sortType: BasicCollection.SORT_TYPE.CLIENT
        }));
    }
});

SingleTaskDependantView.factory = function (options, configOptions) {
    options.selectable = configOptions.selectableGrid;

    return new SingleTaskDependantView(options);
};

module.exports = SingleTaskDependantView;
