const CreateTaskCustomFieldsView = require('../../createTask/CreateTaskCustomFieldsView');

/**
 * @class SingleTaskCommonCustomFieldsView
 * @extends CreateTaskCustomFieldsView
 *
 * @property {TaskModel} model
 * @property {CustomFieldsCollection} collection
 */
const SingleTaskCommonCustomFieldsView = CreateTaskCustomFieldsView.extend({

    id: 'custom-parameters',
    className: 'section__side__custom-parameters',

    template: require('./tpl/SingleTaskCommonCustomFieldsView.hbs'),

    itemViewContainer: 'tbody',

    initialize(options) {
        this.itemViewOptions = {
            taskModel: this.model,
            taskProps: options.taskProps,
            fieldViewMode: 'view'
        };

        this.createCustomFieldsCollection(false, false);
    },

    onRender() {
        if (!this.collection || this.collection.length === 0) {
            this.$el.hide();
        }
    }
});

module.exports = SingleTaskCommonCustomFieldsView;
