const SingleTaskCommonCustomFieldsView = require('./SingleTaskCommonCustomFieldsView');

/**
 * @class SingleTaskCommonCustomOutputFieldsView
 * @extends SingleTaskCommonCustomFieldsView
 *
 * @property {TaskModel} model
 * @property {CustomFieldsCollection} collection
 */
const SingleTaskCommonCustomOutputFieldsView = SingleTaskCommonCustomFieldsView.extend({

    template: require('./tpl/SingleTaskCommonCustomOutputFieldsView.hbs'),

    initialize(options) {
        this.itemViewOptions = {
            taskModel: this.model,
            taskProps: options.taskProps,
            fieldViewMode: 'view'
        };

        this.createCustomFieldsCollection(false, true);
    }
});

module.exports = SingleTaskCommonCustomOutputFieldsView;
