const ChartPlaceholder = require('./ChartPlaceholder');
const rpsChartTooltip = require('./tpl/RPSChartTooltip.hbs');

/**
 * @class BarChartView
 * @extends ChartPlaceholder
 */
const BarChartView = ChartPlaceholder.extend({

    options: _.extend({}, ChartPlaceholder.prototype.options, {

        updateInterval: 0,

        chartOptions: {
            chart: {
                type: 'column'
            },
            title: {},
            xAxis: {
                categories: ['']
            },
            yAxis: {
                min: 0,
                title: {},
                stackLabels: {
                    enabled: true,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                align: 'left',
                x: 50,
                verticalAlign: 'top',
                y: 20,
                floating: true,
                layout: 'vertical',
                backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColorSolid) || 'white',
                borderColor: '#CCC',
                borderWidth: 1,
                shadow: false
            },
            tooltip: {
                formatter() {
                    return rpsChartTooltip(this);
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: true,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
                    },
                    shadow: {
                        width: 4,
                        offsetX: 2,
                        offsetY: 2
                    }
                }
            },
            series: []
        }
    }),

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        this.getChartData = this.getChartData.bind(this);
        this.updateTimer = setInterval(this.getChartData, this.options.updateInterval);
        this.chart = null;

        this.options.chartOptions.title.text = (this.options.title);
        this.options.chartOptions.yAxis.title.text = (this.options.title + ' by Type (Ordered by Priority)');

        this.listenTo(this, 'data', this.reDrawChart);

        this.getChartData();
    },

    getChartData() {
        const self = this;

        return $.ajax({
            url: this.options.url,
            type: 'GET',
            dataType: 'json',
            contentType: 'application/json',
            statistics: true
        }).done(response => {
            self.trigger('data', response);
        });
    },

    reDrawChart(data) {
        /* eslint max-statements: [1, 11] */

        if (!this.chart) {
            this.chart = Highcharts.charts[
                this.ui.chartContainer && this.ui.chartContainer
                    .highcharts(_.clone(this.options.chartOptions))
                    .data('highchartsChart')
            ];
        }

        this.chart.xAxis[0].setCategories(data.categories);

        for (let i = 0; i < data.series.length; ++i) {
            delete data.series[i].color;

            if (this.chart.series.length <= i) {
                this.chart.addSeries(data.series[i], false, false);
            } else {
                this.chart.series[i].update(data.series[i], false, false);
            }
        }

        for (let i = data.series.length; i < this.chart.series.length; ++i) {
            this.chart.series[i].remove(false);
        }

        this.chart.redraw();
    },

    onClose() {
        this.stopListening(this, 'data');

        clearInterval(this.updateTimer);
    }
});

module.exports = BarChartView;
