const ChartPlacehoder = Marionette.ItemView.extend({

    className: 'section__graph',

    template: require('./tpl/ChartPlaceholder.hbs'),

    ui: {
        chartContainer: '.container'
    },

    options: {
        title: '',
        chartOptions: {
            title: {
                margin: 20
            },
            colors: [
                '#5fcc9d',
                '#fb7579',
                '#fedc5b',
                '#91d34c',
                '#9d67a8',
                '#FF0000',
                '#72C3E0',
                '#3B78BC',
                '#A1A1A1',
                '#5E4006'
            ]
        },
        chartCntClass: 'container'
    },

    serializeData() {
        return { title: this.options.title };
    },

    createChartContainers(qnt) {
        let contQnt = this.ui.chartContainer.length;

        while (contQnt < qnt) {
            $('<div/>', { class: 'container' }).appendTo(this.$el);
            contQnt++;
        }

        this.bindUIElements();

        this.ui.chartContainer.css({
            width: '95%',
            height: '600px'
        });
    }
});

module.exports = ChartPlacehoder;
