/* eslint guard-for-in: 0 */

const RPSChartView = require('./RPSChartView');
const ChartPlaceholder = require('./ChartPlaceholder');

/**
     * @class DuplicatedCallsChartView
     * @extends RPSChartView
     */
const DuplicatedCallsChartView = RPSChartView.extend({
    ui: {
        chartContainer: '.container'
    },

    initialize(options) {
        this.options = _.extend({}, ChartPlaceholder.prototype.options, { chartOptions: {
            chart: {
                polar: true,
                type: 'line',
                renderTo: 'duplicated_calls'
            },
            title: { text: options.specifiedChartName },
            credits: { text: 'Yandex.com', href: 'http://company.yandex.com/' },
            pane: { size: '80%' },
            xAxis: {
                categories: [],
                tickmarkPlacement: 'on',
                lineWidth: 0
            },
            yAxis: {
                gridLineInterpolation: 'polygon',
                minorTickInterval: 'auto',
                lineWidth: 0
            },
            tooltip: { shared: true },
            legend: {
                y: 70,
                align: 'right',
                layout: 'vertical',
                verticalAlign: 'top'
            },
            plotOptions: {
                line: { animation: true },
                series: { enableMouseTracking: true }
            },
            series: [
                { name: 'Average Tries', pointPlacement: 'on', data: [] },
                { name: 'Maximum Tries', pointPlacement: 'on', data: [] },
                { name: 'Amount', pointPlacement: 'on', data: [] }
            ]
        }}, options);

        this.options.chartOptions = _.extend(
            {},
            ChartPlaceholder.prototype.options.chartOptions,
            this.options.chartOptions
        );
    },

    preProcessData(data) {
        const categories = Object.keys(data);

        for (const i in categories) {
            const st = data[categories[i]];

            this.options.chartOptions.series[0].data.push(st.avg_tries);
            this.options.chartOptions.series[1].data.push(st.max_tries);
            this.options.chartOptions.series[2].data.push(st.amount);
        }

        this.options.chartOptions.xAxis.categories = categories;

        return this.options.chartOptions;
    }

});

module.exports = DuplicatedCallsChartView;

