/* eslint camelcase: 0 */
/* eslint guard-for-in: 0 */
/* eslint max-statements: [1, 19] */
/* eslint complexity: [1, 9] */

const RPSChartView = require('./RPSChartView');
const ChartPlaceholder = require('./ChartPlaceholder');

/**
 * @class RTPMChartView
 * @extends RPSChartView
 */
const RTPMChartView = RPSChartView.extend({

    initialize(options) {
        this.options = _.extend(
            {},
            ChartPlaceholder.prototype.options,
            { chartOptions: RTPMChartView.RTPM_CHART_BASIC_OPTIONS },
            options
        );

        this.options.chartOptions = _.extend(
            {},
            ChartPlaceholder.prototype.options.chartOptions,
            this.options.chartOptions,
            { title: { text: options.specifiedChartName }}
        );
    },

    preProcessData(data) {
        return RTPMChartView.processRtpmData(this.options.chartOptions, data);
    }

}, {

    processRtpmData(options, data) {
        options = _.clone(options);
        const categories = [];

        for (const meth in data) {
            if (meth.includes('.__repr__')) {
                categories.push(meth);
            }
        }

        categories.sort((a, b) => {
            return data[b].amount - data[a].amount;
        });

        const candles = [];
        const mean_spline = [];
        const amount_spline = [];

        for (const i in categories) {
            const st = data[categories[i]];

            mean_spline.push(st.mean);
            amount_spline.push(parseInt(st.amount, 10));
            candles.push([
                st.min || 1,
                st.lower_quartile || 1,
                st.median || 1,
                st.upper_quartile || 1,
                st.max || 1
            ]);
        }

        options.xAxis.categories = categories;
        options.series[0].data = candles;
        options.series[1].data = mean_spline;
        options.series[2].data = amount_spline;

        return options;
    },

    RTPM_CHART_BASIC_OPTIONS: {
        title: { text: 'Response Time per Method', margin: 25 },
        credits: { text: 'Yandex.com', href: 'http://company.yandex.com/' },
        xAxis: {
            categories: [],
            labels: { rotation: -45 }
        },
        yAxis: [
            {
                title: { text: '' },
                type: 'logarithmic',
                minorTickInterval: 'auto',
                min: 1
            },
            {
                title: { text: 'Amount, requests (logarithmic)' },
                type: 'logarithmic',
                opposite: true,
                min: 1
            }
        ],
        legend: {
            x: 0,
            y: 10,
            align: 'center',
            verticalAlign: 'top',
            layout: 'horizontal',
            floating: true,
            borderWidth: 0
        },
        tooltip: { crosshairs: true },
        plotOptions: {
            scatter: { animation: true },
            boxplot: {
                animation: true,
                colorByPoint: true,
                fillColor: '#FAFAFA',
                stemDashStyle: 'dot'
            }
        },
        series: [
            {
                name: 'Method Response Time',
                type: 'boxplot',
                data: [],
                tooltip: { headerFormat: '<em>{point.key}</em><br/>', valueSuffix: ' ms' }
            },
            {
                name: 'Mean',
                type: 'scatter',
                marker: { radius: 2 },
                data: [],
                tooltip: { valueSuffix: ' ms' }
            },
            {
                name: 'Amount',
                type: 'scatter',
                data: [],
                yAxis: 1,
                tooltip: { valueSuffix: ' calls' }
            }
        ]
    }
});

module.exports = RTPMChartView;
