// eslint-disable-next-line no-unused-vars
const ChartPlaceholder = require('./ChartPlaceholder');
const XmlrpcStatisticsContent = require('./XmlrpcStatisticsContent');

/**
 * @class RestStatisticsContent
 * @extends XmlrpcStatisticsContent
 */
const RestStatisticsContent = XmlrpcStatisticsContent.extend({

    className: 'section__i section__i_stat',

    template: require('./tpl/XmlrpcContent.hbs'),

    modelEvents: {
        'change:id': 'onStatResourceChange'
    },

    options: {
        baseSourceUrl: 'https://proxy.sandbox.yandex-team.ru/'
    },

    chartsConfig: {
        rps: {
            chartName: 'Average calls RPS per hour | REST',
            chartView: require('./RPSChartView'),
            regionName: 'rps',
            sourceName: 'rps.json'
        },
        methods: {
            chartName: 'Response time per method | REST',
            chartView: require('./RTPMChartView'),
            regionName: 'methods',
            sourceName: 'methods.json'
        },
        duplicates: {
            chartName: 'Duplicated method calls | REST',
            chartView: require('./DuplicatedCallsChartView'),
            regionName: 'duplicates',
            sourceName: 'duplicated_calls.json'
        },
        topClients: {
            chartName: 'Top 25 clients calls per host | REST',
            chartView: require('./TopClientsChartView'),
            regionName: 'topClients',
            sourceName: 'top_clients.json'
        },
        topClientsRps: {
            chartName: 'REST calls per Hour: ',
            chartView: require('./TopClientsRPSChartView'),
            regionName: 'topClientsRps',
            sourceName: 'top_clients.rps.json'
        },
        topClientsMethods: {
            chartName: 'Response time per Method | REST',
            chartView: require('./TopClientsRTPMChartView'),
            regionName: 'topClientsMethods',
            sourceName: 'top_clients.methods.json'
        }
    }
});

module.exports = RestStatisticsContent;
