const BarChartView = require('./BarChartView');

/**
 * @class TasksStatisticsContent
 * @extends Backbone.Marionette.Layout
 */
const TasksStatisticsContent = Marionette.Layout.extend({

    template: require('./tpl/TasksContent.hbs'),

    chartsConfig: {
        enqueued: {
            regionName: 'enqueued',
            chartName: 'Enqueued tasks',
            options: {
                url: 'https://sandbox.yandex-team.ru/sandbox/api/json/statistics/tasks/enqueued',
                title: 'Enqueued tasks [top 10]',
                updateInterval: 5000
            }
        },
        executing: {
            regionName: 'executing',
            chartName: 'Executing tasks',
            options: {
                url: 'https://sandbox.yandex-team.ru/sandbox/api/json/statistics/tasks/executing',
                title: 'Executing tasks [top 10]',
                updateInterval: 10000
            }
        },
        queue: {
            regionName: 'queue',
            chartName: 'Enqueued tasks queue time',
            options: {
                url: 'https://sandbox.yandex-team.ru/sandbox/api/json/statistics/tasks/queue_time',
                title: 'Enqueued tasks queue time [top 10]',
                updateInterval: 30000
            }
        }
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.showCharts();
    },

    showCharts() {
        Object.keys(this.chartsConfig).forEach(function (configItemKey) {
            const region = this[this.chartsConfig[configItemKey].regionName];

            region.close();
            region.show(new BarChartView(this.chartsConfig[configItemKey].options));
        }, this);
    }
});

module.exports = TasksStatisticsContent;
