// eslint-disable-next-line no-unused-vars
const RPSChartView = require('./RPSChartView');
const ChartPlaceholder = require('./ChartPlaceholder');
const TopClientsChartView = require('./TopClientsChartView');

/**
 * @class TopClientsRPSChartView
 * @extends TopClientsChartView
 */
const TopClientsRPSChartView = TopClientsChartView.extend({

    initialize(options) {
        this.options = _.extend(
            {},
            ChartPlaceholder.prototype.options,
            { chartOptions: TopClientsChartView.RPS_CHART_BASIC_OPTIONS },
            options
        );

        this.options.chartOptions = _.extend(
            {},
            ChartPlaceholder.prototype.options.chartOptions,
            this.options.chartOptions
        );
        this.options.chartOptions.title.text = options.specifiedChartName;
    },

    onRender() {
        const hosts = Object.keys(this.options.data);

        this.createChartContainers(hosts.length);

        hosts.forEach(function (host, index) {
            const options = TopClientsChartView.processRpsData(
                _.clone(this.options.chartOptions),
                Object.keys(this.options.data[host]),
                this.options.data[host]
            );

            options.title.text = (this.options.chartOptions.title.text + host);

            this.ui.chartContainer.eq(index).highcharts(options);
        }, this);
    }
});

module.exports = TopClientsRPSChartView;
