const ChartPlaceholder = require('./ChartPlaceholder');
const RTPMChartView = require('./RTPMChartView');

/**
 * @class TopClientsRTPMChartView
 * @extends RTPMChartView
 */
const TopClientsRTPMChartView = RTPMChartView.extend({

    options() {
        return _.extend(
            {},
            ChartPlaceholder.prototype.options,
            { chartOptions: RTPMChartView.RTPM_CHART_BASIC_OPTIONS }
        );
    },

    onRender() {
        const hosts = Object.keys(this.options.data);

        this.createChartContainers(hosts.length);

        hosts.forEach(function (host, index) {
            const options = RTPMChartView.processRtpmData(_.clone(this.options.chartOptions), this.options.data[host]);

            options.title.text = ('Response time per Method for: ' + host);

            this.ui.chartContainer.eq(index).highcharts(options);
        }, this);
    }
});

module.exports = TopClientsRTPMChartView;
