const ChartPlaceholder = require('./ChartPlaceholder');

/**
 * @class XmlrpcStatisticsContent
 * @extends Backbone.Marionette.Layout
 */
const XmlrpcStatisticsContent = Marionette.Layout.extend({

    className: 'section__i section__i_stat',

    template: require('./tpl/XmlrpcContent.hbs'),

    modelEvents: {
        'change:id': 'onStatResourceChange'
    },

    options: {
        baseSourceUrl: 'https://proxy.sandbox.yandex-team.ru/'
    },

    chartsConfig: {
        rps: {
            chartName: 'Average calls RPS per hour | XMLRPC',
            chartView: require('./RPSChartView'),
            regionName: 'rps',
            sourceName: 'rps.json'
        },
        methods: {
            chartName: 'Response time per method | XMLRPC',
            chartView: require('./RTPMChartView'),
            regionName: 'methods',
            sourceName: 'methods.json'
        },
        duplicates: {
            chartName: 'Duplicated method calls | XMLRPC',
            chartView: require('./DuplicatedCallsChartView'),
            regionName: 'duplicates',
            sourceName: 'duplicated_calls.json'
        },
        topClients: {
            chartName: 'Top 25 clients calls per host | XMLRPC',
            chartView: require('./TopClientsChartView'),
            regionName: 'topClients',
            sourceName: 'top_clients.json'
        },
        topClientsRps: {
            chartName: 'XMLRPC calls per hour: ',
            chartView: require('./TopClientsRPSChartView'),
            regionName: 'topClientsRps',
            sourceName: 'top_clients.rps.json'
        },
        topClientsMethods: {
            chartName: 'Response time per method | XMLRPC',
            chartView: require('./TopClientsRTPMChartView'),
            regionName: 'topClientsMethods',
            sourceName: 'top_clients.methods.json'
        }
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.showPlaceholders();

        if (this.model.get('id')) {
            this.loadAllChartsData();
        }
    },

    showPlaceholders() {
        Object.keys(this.chartsConfig).forEach(function (configItemKey) {
            const region = this[this.chartsConfig[configItemKey].regionName];

            region.close();
            region.show(new ChartPlaceholder({
                title: this.chartsConfig[configItemKey].chartName
            }));
        }, this);
    },

    loadAllChartsData() {
        Object.keys(this.chartsConfig).forEach(function (configItemKey) {
            const self = this;

            this.loadChartData(configItemKey).done((response, state, xhr) => {
                const chartContent = JSON.parse(xhr.responseText);
                const ChartView = self.chartsConfig[configItemKey].chartView;
                const region = self[self.chartsConfig[configItemKey].regionName];

                region.close();
                region.show(new ChartView({
                    data: chartContent,
                    specifiedChartName: self.chartsConfig[configItemKey].chartName
                }));
            });
        }, this);
    },

    loadChartData(chartConfigKey) {
        return $.ajax({
            url: this.options.baseSourceUrl +
                this.model.get('id') + '/' +
                this.chartsConfig[chartConfigKey].sourceName,
            type: 'GET',
            dataType: 'json',
            contentType: 'application/json',
            statistics: true
        });
    },

    onStatResourceChange() {
        this.loadAllChartsData();
    }
});

module.exports = XmlrpcStatisticsContent;
