const app = require('../../app');
const ReleaseFilter = require('../releases/ReleaseFilter');
const AuthorSuggestView = require('../controlSection/filter/suggest/AuthorSuggestView');
// eslint-disable-next-line no-unused-vars
const BasicFilterLayout = require('../controlSection/filter/BasicFilterLayout');
const TaskTypeAutocompleteView = require('../controlSection/filter/selects/autocomplete/TaskTypeAutocompleteView');

/**
 * @class TaskTypesFilter
 * @extends ReleaseFilter
 *
 * @property {TaskTypeFilterModel} model
 * @property {Marionette.Region} typeSelector
 * @property {Marionette.Region} ownerSelector
 */
const TaskTypesFilter = ReleaseFilter.extend({

    className: 'tasktype_filter_view',

    template: require('./tpl/TaskTypesFilter.hbs'),

    /** REGIONS ARE DEFINED DIRECTLY IN THE TEMPLATE */

    onRender() {
        this.typeSelector.close();
        this.ownerSelector.close();

        this.typeSelector.show(this.getTypeSelector());
        this.ownerSelector.show(this.getOwnerSelector());

        this.bindUIElements();
    },

    getTypeSelector() {
        return new TaskTypeAutocompleteView({
            items: this.options.props.types,
            value: this.model.get('type'),
            model: this.model,
            showAnyItem: true,
            placeHolder: 'Task types',
            modelTargetKey: 'type',
            selectClassName: 'filter_type'
        });
    },

    getOwnerSelector() {
        return new AuthorSuggestView({
            model: this.model,
            modelTargetKey: 'owner',
            defaultValue: this.model.get('author')
        });
    },

    serializeData() {
        return {};
    },

    updateLastFilter(filterValues) {
        app.setDefaultFilter(filterValues);
        filterValues.saveFilterState();
    }
});

module.exports = TaskTypesFilter;
