/**
 * @class BasicGridBodyView
 * @extends Backbone.Marionette.CollectionView
 *
 * @property {Backbone.Collection} collection
 */
const BasicGridBodyView = Marionette.CollectionView.extend({

    tagName: 'tbody',
    itemView: null,

    collectionEvents: {
        sort: 'render'
    },

    initialize() {
        this.itemViewOptions = this.getItemViewOptions();
    },

    getItemViewOptions() {
        let opts = {};

        if (this.options && typeof this.options.selectable !== 'undefined') {
            opts.selectable = this.options.selectable;
            opts.expandable = this.options.expandable;
            opts.editable = this.options.editable;
        }

        opts = _.extend({}, opts, this.options.itemViewOptions);

        delete this.options.itemViewOptions;

        return opts;
    },

    onClose() {
        this.$el.empty();
    },

    // Deattach default events and stop propagating child events
    _initialEvents() { },

    addChildViewEventForwarding() { }
});

module.exports = BasicGridBodyView;
