const BasicCollection = require('../../../collection/BasicCollection');

/**
 * @class BasicGridView
 * @extends Marionette.Layout
 *
 * @property {BasicCollection} collection
 */
const BasicGridView = Marionette.Layout.extend({

    className: 'section__t app_tasks',
    template: require('./tpl/BasicGridView.hbs'),

    ui: {
        loader: '.app_tasks_loader'
    },

    options: {
        sortable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,
        selectable: true,

        bodyClass: null,
        headerClass: null,
        footerClass: null,

        autoUpdateEnabled: false
    },

    collectionEvents: {
        'update:start': 'showLoader',
        'update:complete': 'hideLoader'
    },

    /** REGIONS DEFINED DIRECTLY IN THE TEMPLATE */

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        Backbone.trigger('autoupdate:ready');

        if (this.options.autoUpdateEnabled) {
            this.listenTo(Backbone, 'autoupdate:on', this.turnOnAutoupdate);
            this.listenTo(Backbone, 'autoupdate:off', this.turnOffAutoupdate);
        }
    },

    onBeforeShow() {
        if (this.options.headerClass !== null) {
            this.theader.close();
            this.theader.show(this.getHeader());
        }

        if (this.options.bodyClass !== null) {
            this.tbody.close();
            this.tbody.show(this.getBody());
        }

        if (this.options.footerClass !== null) {
            this.tfoot.close();
            this.tfoot.show(this.getFooter());
        }
    },

    getHeader() {
        const HeaderClass = this.options.headerClass;

        return new HeaderClass(this.getOptions());
    },

    getBody() {
        const BodyClass = this.options.bodyClass;

        return new BodyClass(this.getOptions());
    },

    getFooter() {
        const FooterClass = this.options.footerClass;

        return new FooterClass(this.getOptions());
    },

    getOptions() {
        return {
            model: this.model,
            isModal: this.options.isModal,
            sortable: this.options.sortable,
            editable: this.options.editable,
            sortType: this.options.sortType,
            collection: this.collection,
            expandable: this.options.expandable,
            unfilterable: this.options.unfilterable,
            selectable: this.options.selectable,
            itemViewOptions: this.options.itemViewOptions || {}
        };
    },

    showLoader() {
        /* Feat SANDBOX-5378
            this.ui.loader.fadeIn(150);
            this.ui.loader.removeClass('loader_hide');
        */
    },

    hideLoader() {
        /* Feat SANDBOX-5378
            this.ui.loader.fadeOut(300);
            this.ui.loader.addClass('loader_hide');
        */
    },

    turnOnAutoupdate(interval) {
        this.collection.activateAutoupdate(interval);
    },

    turnOffAutoupdate() {
        this.collection.deActivateAutoupdate(0, true);
    },

    onClose() {
        this.turnOffAutoupdate();

        this.stopListening(Backbone, 'autoupdate:on');
        this.stopListening(Backbone, 'autoupdate:off');
    }
});

module.exports = BasicGridView;
