const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');
const TasksCollection = require('../../../collection/TasksCollection');

/**
 * @class BulkTaskRemoveConfirmView
 * @extends BasicConfirmDialogView
 *
 * @property {Backbone.Collection} collection
 */
const BulkTaskRemoveConfirmView = BasicConfirmDialogView.extend({

    template: require('./tpl/BulkTaskRemoveConfirmView.hbs'),

    events: {
        approve: 'onApprove'
    },

    onApprove() {
        this.collection
            .batchAction(TasksCollection.BATCH_OPERATIONS.DELETE)
            .always(_.isFunction(this.options.callback) ? this.options.callback : null);

        this.close();
    },

    onCancel() {
        if (_.isFunction(this.options.callback)) {
            this.options.callback();
        }

        this.close();
    },

    serializeData() {}

});

module.exports = BulkTaskRemoveConfirmView;
