const TaskResourcesCollection = require('../../../collection/TaskResourcesCollection');
const TaskRemoveConfirmView = require('./TaskRemoveConfirmView');

/**
 * @class ResourceRemoveConfirmView
 * @extends TaskRemoveConfirmView
 *
 * @property {ResourceModel} model
 */
const ResourceRemoveConfirmView = TaskRemoveConfirmView.extend({

    template: require('./tpl/ResourceRemoveConfirmView.hbs'),

    onApprove() {
        TaskResourcesCollection.batchAction(TaskResourcesCollection.BATCH_OPERATIONS.DELETE, [this.model]);
        this.close();
    }
});

module.exports = ResourceRemoveConfirmView;
