const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');
const TasksCollection = require('../../../collection/TasksCollection');

/**
 * @class TaskRemoveConfirmView
 * @extends BasicConfirmDialogView
 *
 * @property {TaskModel} model
 */
const TaskRemoveConfirmView = BasicConfirmDialogView.extend({

    template: require('./tpl/TaskRemoveConfirmView.hbs'),

    events: {
        approve: 'onApprove'
    },

    onApprove() {
        TasksCollection.batchAction(TasksCollection.BATCH_OPERATIONS.DELETE, [this.model]);
        this.close();
    },

    serializeData() {
        const id = String(this.model.get('id'));

        return {
            id: (id.substring(0, id.length - 4) + ' ' + id.substring(id.length - 4)),
            type: this.model.get('type')
        };
    }

});

module.exports = TaskRemoveConfirmView;
