const SingleTaskResourcesGridHeaderView = require('./SingleTaskResourcesGridHeaderView');
const SingleTaskResourcesGridBodyView = require('./SingleTaskResourcesGridBodyView');
const TaskResourcesGridView = require('./TaskResourcesGridView');
const BasicCollection = require('../../../collection/BasicCollection');
const BasicGridView = require('../basicGrid/BasicGridView');

/**
 * @class TasksGridView
 * @extends BasicGridView
 * @property {TasksCollection} collection
 */
const SingleTaskResourcesGridView = TaskResourcesGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: false,
        sortable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: SingleTaskResourcesGridBodyView,
        headerClass: SingleTaskResourcesGridHeaderView
    })
});

module.exports = SingleTaskResourcesGridView;
