const TaskResourcesRowView = require('./TaskResourcesRowView');
const clipboardClientMixin = require('../../components/clipboardClient/ClipboardClientMixin');

/**
 * @class SingleTaskResourcesRowView
 * @extends TaskResourcesRowView
 */
const SingleTaskResourcesRowView = TaskResourcesRowView.extend({

    template: require('./tpl/SingleTaskResourceGridRow.hbs'),

    onRender() {
        clipboardClientMixin.initializeClipboardClient(
            '.http-proxy-copier',
            'Resource ID has been copied to clipboard.'
        );

        clipboardClientMixin.initializeClipboardClient(
            '.skynet-proxy-copier',
            'Skynet copier link has been copied to clipboard.'
        );
    }
});

module.exports = SingleTaskResourcesRowView;
