const TaskResourcesGridHeaderView = require('./TaskResourcesGridHeaderView');
const TaskResourcesGridBodyView = require('./TaskResourcesGridBodyView');
const BasicCollection = require('../../../collection/BasicCollection');
const BasicGridView = require('../basicGrid/BasicGridView');

/**
 * @class TasksGridView
 * @extends BasicGridView
 * @property {TasksCollection} collection
 */
const TaskResourcesGridView = BasicGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: false,
        sortable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: TaskResourcesGridBodyView,
        headerClass: TaskResourcesGridHeaderView
    })
});

module.exports = TaskResourcesGridView;
