// eslint-disable-next-line no-unused-vars
const TaskRowView = require('./../tasksGrid/row/TaskRowView');
const TaskSelectorView = require('./../tasksGrid/row/TaskSelectorView');
const BasicTaskLayout = require('./../tasksGrid/row/BasicTaskLayout');

const clipboardClientMixin = require('../../components/clipboardClient/ClipboardClientMixin');

/**
 * @class TaskResourcesRowView
 * @extends BasicTaskLayout
 */
const TaskResourcesRowView = BasicTaskLayout.extend({

    tagName: 'tr',

    template: require('./tpl/TaskResourceGridRow.hbs'),

    options: {
        selectable: false
    },

    ui: {
        secondaryLinksCnt: '.secondary_links'
    },

    modelEvents: {
        sync: 'render'
    },

    events: {
        dblclick: 'onRowSelect'
    },

    onRender() {
        if (this.options.selectable) {
            this.selector.close();
            this.selector.show(new TaskSelectorView({
                model: this.model
            }));
        }

        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'ID has been copied to clipboard.'
        );

        clipboardClientMixin.initializeClipboardClient(
            '.skynet-proxy-copier',
            'Skynet copier link has been copied to clipboard.'
        );
    },

    serializeData() {
        const serialized = _.clone(this.model.attributes);

        serialized.state = serialized.state.toLowerCase();
        serialized.isModal = this.options.isModal;
        serialized.created = this.serializeCreated();
        serialized.selectable = this.options.selectable;
        serialized.attributes = this.model.serializeAttrs();

        if (serialized.http.links) {
            serialized.http.statistics = {
                all: serialized.http.links.length || 0,
                storages: serialized.http.links.filter(a => {
                    return a.indexOf('sandbox-storage') !== -1;
                }).length || 0
            };
        }

        return serialized;
    },

    onRowSelect() {
        this.model.set('selected', true);

        $('.page').removeClass('page_modal_showed');
    }
});

module.exports = TaskResourcesRowView;
