const error = require('../../../../error');
const TaskRowEmptyView = require('../row/TaskRowEmptyView');
const BasicGridBodyView = require('../../basicGrid/BasicGridBodyView');

/**
 * @class TaskGridBodyView
 * @extends BasicGridBodyView
 */
const TaskGridBodyView = BasicGridBodyView.extend({

    itemView: require('../row/TaskRowView'),
    emptyView: TaskRowEmptyView,

    collectionEvents: {
        sort: 'render'
    },

    initialize() {
        BasicGridBodyView.prototype.initialize.apply(this, arguments);
    },

    onClose() {
        this.$el.empty();
    },

    accumulatedActionError(errorObj) {
        error.message('Server refused action «' + errorObj.action + '» with message: ' + errorObj.message, {
            reload: false,
            autoClosePeriod: 3000
        });
    }
});

module.exports = TaskGridBodyView;
