const TaskGridHeaderView = require('./TaskGridHeaderView');
const TaskGridBodyView = require('./TaskGridBodyView');
const BasicCollection = require('../../../../collection/BasicCollection');
const BasicGridView = require('../../basicGrid/BasicGridView');

/**
 * @class TasksGridView
 * @extends BasicGridView
 * @property {TasksCollection} collection
 */
const TasksGridView = BasicGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: true,
        sortable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: TaskGridBodyView,
        headerClass: TaskGridHeaderView,

        autoUpdateEnabled: true
    })
});

module.exports = TasksGridView;
