const TaskImportantTogglerView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 't__min t__center',

    template: require('./tpl/TaskImportantTogglerView.hbs'),

    ui: {
        toggler: '.button'
    },

    events: {
        'click @ui.toggler': 'onToggle'
    },

    modelEvents: {
        'change:important': 'render'
    },

    onToggle() {
        this.model.toggleImportant();
    },

    serializeData() {
        return {
            important: this.model.get('important')
        };
    }
});

module.exports = TaskImportantTogglerView;
