/**
 * @class TaskRowControlsView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const TaskRowControlsView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 't__owner-priority',

    template: require('./tpl/TaskRowControlsView.hbs'),

    behaviors: {
        TaskControllerBehavior: {}
    },

    modelEvents: {
        'change:hostScore': 'render',
        'change:priority': 'render',
        'change:_duplicating': 'render'
    },

    serializeData() {
        const hostScore = (this.model.get('hostScore') || []);

        return {
            hostScore: (_.isArray(hostScore) ? hostScore[0] : ''),
            execution: this.model.get('execution'),
            priority: this.model.get('priority'),
            owner: this.model.get('owner'),
            canBeEdited: this.model.canBeEdited(),
            canBeStopped: this.model.canBeStopped(),
            canBeClonned: this.model.canBeClonned(),
            canBeDeleted: this.model.canBeDeleted(),
            canBeExecuted: this.model.canBeExecuted(),
            canPriorityBeIncreased: this.model.canPriorityBeIncreased()
        };
    }
});

module.exports = TaskRowControlsView;
