/**
 * @class TaskSelectorView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel|TaskResourceModel} model
 */
const TaskSelectorView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 't__min t__check app_task_select',
    template: require('./tpl/TaskSelectorView.hbs'),

    ui: {
        selector: '.check'
    },

    events: {
        'bemmy:set': 'onTaskSelect',
        'click @ui.selector': 'setLastShifted'
    },

    modelEvents: {
        'change:selected': 'onTaskStateUpdated'
    },

    onRender() {
        this.ui.selector.bemmyCheck();
    },

    onTaskSelect() {
        this.model.toggleSelected();
    },

    onTaskStateUpdated(model, isSelected) {
        const b = this.ui.selector.bemmy();

        if (b && b.checked !== isSelected) {
            b.checked = Boolean(isSelected);
            b.trigger('change:checked', b.checked);
        }
    },

    setLastShifted(evtObj) {
        this.model.collection.setLastShifted(evtObj.shiftKey);
    },

    serializeData() {
        return {
            selected: this.model.get('selected')
        };
    }

});

module.exports = TaskSelectorView;
