// eslint-disable-next-line no-unused-vars
const TaskCompactRowEmptyView = require('../row/TaskCompactRowEmptyView');
const BasicGridBodyView = require('../../basicGrid/BasicGridBodyView');
const app = require('../../../../app');

/**
 * @class TaskCompactGridBodyView
 * @extends BasicGridBodyView
 */
const TaskCompactGridBodyView = BasicGridBodyView.extend({

    itemView: require('../row/TaskCompactRowView'),
    emptyView: require('../row/TaskCompactRowEmptyView'),

    collectionEvents: {
        sort: 'render'
    },

    onClose() {
        this.$el.empty();
    },

    getItemViewOptions() {
        return _.extend({
            isModal: this.options.isModal
        }, BasicGridBodyView.prototype.getItemViewOptions.apply(this), {
            isAdmin: (app.getCurrentUser() ? app.getCurrentUser().isAdmin() : false)
        });
    }
});

module.exports = TaskCompactGridBodyView;
