const BasicGridHeaderView = require('../../basicGrid/BasicGridHeaderView');

/**
 * @class TaskCompactGridHeaderView
 * @extends BasicGridHeaderView
 *
 * @property {TasksCollection} collection
 */
const TaskCompactGridHeaderView = BasicGridHeaderView.extend({

    template: require('./tpl/TaskCompactGridHeaderView.hbs'),

    options: _.extend({}, BasicGridHeaderView.prototype.options, {
        sortKeys: ['id', 'type', 'status', 'owner', 'updated', 'priority'],
        childrenLoadingClass: 'children-loading',
        spinnerLoadingClass: 'spinner_hidden'
    }),

    ui: _.extend({}, BasicGridHeaderView.prototype.ui, {
        childrenToggler: '.toggle-children',
        filteredToggler: '.toggle-filtered',
        idColumnContainer: '.t__id_col'
    }),

    events: _.extend({}, BasicGridHeaderView.prototype.events, {
        'click @ui.childrenToggler': 'onToggleChildren',
        'click @ui.filteredToggler': 'onToggleFiltered'
    }),

    onToggleChildren() {
        const self = this;

        this.ui.idColumnContainer.addClass(this.options.childrenLoadingClass);
        this.ui.idColumnContainer.removeClass(this.options.spinnerLoadingClass);

        this.collection.trigger('update:start');
        this.collection.fetchChildren().done(() => {
            self.ui.idColumnContainer.addClass(self.options.spinnerLoadingClass);
            self.ui.idColumnContainer.removeClass(self.options.childrenLoadingClass);
            self.collection.trigger('update:complete');
            self.collection.trigger('reset');
        });
    },

    onToggleFiltered() {
        this.ui.idColumnContainer.addClass(this.options.childrenLoadingClass);
        this.ui.idColumnContainer.removeClass(this.options.spinnerLoadingClass);

        this.collection.trigger('update:start');
        this.model.fetchUnfilteredChildren();
    }
});

module.exports = TaskCompactGridHeaderView;
