const BasicCollection = require('../../../../collection/BasicCollection');
const BasicGridView = require('../../basicGrid/BasicGridView');

/**
 * @class TasksCompactGridView
 * @extends BasicGridView
 * @property {TasksCollection} collection
 */
const TasksCompactGridView = BasicGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: true,
        expandable: false,
        sortable: true,
        editable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: require('./TaskCompactGridBodyView'),
        headerClass: require('./TaskCompactGridHeaderView')
    })
});

module.exports = TasksCompactGridView;
