/**
 * @class TaskCompactRowControlsView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const TaskCompactRowControlsView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 't__owner-priority t__owner-priority_inline',

    template: require('./tpl/TaskCompactRowControlsView.hbs'),

    ui: {
        importantTrigger: '.important_trigger'
    },

    events: {
        'click @ui.importantTrigger': 'onImportantToggle'
    },

    behaviors: {
        TaskControllerBehavior: {}
    },

    modelEvents: {
        'changed:_duplicating': 'render'
    },

    onImportantToggle(evtObj) {
        evtObj.preventDefault();
        this.model.toggleImportant();
    },

    serializeData() {
        return {
            owner: this.model.get('owner'),
            editable: this.options.editable,
            canBeEdited: this.model.canBeEdited(),
            canBeClonned: this.model.canBeClonned(),
            canBeStopped: this.model.canBeStopped(),
            canBeDeleted: this.model.canBeDeleted(),
            canBeExecuted: this.model.canBeExecuted()
        };
    }
});

module.exports = TaskCompactRowControlsView;
