/**
 * @class TaskCompactRowPriorView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const TaskCompactRowPriorView = Marionette.ItemView.extend({

    tagName: 'p',
    className: 't__priority',

    template: require('./tpl/TaskCompactRowPriorView.hbs'),

    modelEvents: {
        'change:hostScore': 'render',
        'change:priority': 'render'
    },

    behaviors: {
        TaskControllerBehavior: {}
    },

    serializeData() {
        /* eslint camelcase: 0 */

        const priority = this.model.get('priority');
        const hostScore = (this.model.get('hostScore') || []);

        return {
            hostScore: (_.isArray(hostScore) ? hostScore[0] : ''),
            prior_class: priority ? this.shortPriorClass(priority.class) : '',
            sub_class: priority ? this.shortPriorClass(priority.subclass) : '',
            canPriorityBeIncreased: this.model.canPriorityBeIncreased()
        };
    },

    shortPriorClass(toShort) {
        switch (toShort) {
            case 'USER': {
                return 'USR';
            }
            case 'SERVICE': {
                return 'SRV';
            }
            case 'BACKGROUND': {
                return 'BGR';
            }
            case 'LOW': {
                return 'L';
            }
            case 'HIGH': {
                return 'H';
            }
            case 'NORMAL': {
                return 'N';
            }
            default: {
                return 'N/A';
            }
        }
    }
});

module.exports = TaskCompactRowPriorView;
