const lazyDash = require('../../helpers/utils/lazyDash');

const QuickCompositeView = Marionette.CompositeView.extend({

    constructor() {
        Marionette.CollectionView.apply(this, arguments);

        this._lazyTimeout = this.options.lazy || 0;
        this.setDefaultFilter();
    },

    _initialEvents() {
        // Prevent attach default events
    },

    addChildViewEventForwarding() {

    },

    setDefaultFilter() {
        this.setFilter(() => {
            return true;
        });
    },

    setFilter(filter) {
        this._filter = filter;
    },

    _renderChildren() {
        if (this._lazyTimeout) {
            setTimeout(this._realRenderChildren.bind(this), this._lazyTimeout);
        } else {
            // Filter triggered only in _realRenderChildren()
            this._lazyTimeout++;
            Marionette.CompositeView.prototype._renderChildren.call(this);
        }
    },

    _realRenderChildren() {
        const _this = this;

        if (this._isRenderChildren) {
            return;
        }

        this._isRenderChildren = true;

        this.startBuffering();

        this.closeEmptyView();
        this.closeChildren();

        lazyDash(this.collection)
            .filter((item, index) => {
                return _this._filter(item, index);
            })
            .forEach((item, index) => {
                _this.addItemView(item, _this.getItemView(item), index);
            })
            .then(() => {
                _this.endBuffering();
                _this._isRenderChildren = false;
                _this.collection.trigger('change:items');
            });
    }

});

module.exports = QuickCompositeView;
