from __future__ import absolute_import

from six.moves import urllib_parse as urlparse

from sandbox.common import api as common_api
from sandbox.common import urls as common_urls

url = urlparse.urlparse(common_urls.server_url())
host = url.netloc
schemes = [url.scheme]


class Api(common_api.Api):
    swagger = "2.0"
    schemes = schemes
    host = host
    basePath = "/api/v1.0"
    info = dict(
        title="Sandbox JSON API",
        description="JSON API for using Sandbox",
        contact=dict(email="sandbox@yandex-team.ru"),
        version="1.0"
    )
    consumes = ["application/json; charset=utf-8"]
    produces = ["application/json; charset=utf-8"]
    securityDefinitions = dict(
        oauth=dict(
            type="oauth2",
            tokenUrl="https://sandbox.yandex-team.ru/oauth/",
            flow="application",
            scopes=dict(
                authenticated="authenticated user actions",
                task="sandbox task actions",
                admin="admin actions"
            )
        )
    )
