"""
Batch operations on various objects
"""
from __future__ import absolute_import

from sandbox.common import api
import sandbox.common.types.client as ctc

from .api import Api
from . import schemas


class TasksOp(Api.Path("/batch/tasks/{operation}")):
    class Put(api.Put):
        """ Mass operation on task objects """

        operation = api.Enum(
            "Operation type",
            values=["start", "stop", "delete", "suspend", "resume", "increase_priority", "expire"],
            scope=api.Scope.PATH,
            required=True
        )
        data = schemas.batch.BatchData("Tasks operation data", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            """ Per-object operation result """
            schema = api.Array(schemas.batch.BatchResult)


class SchedulersOp(Api.Path("/batch/schedulers/{operation}")):
    class Put(api.Put):
        """ Mass operation on scheduler objects """

        operation = api.Enum(
            "Operation type",
            values=["start", "stop", "delete"],
            scope=api.Scope.PATH,
            required=True
        )
        data = schemas.batch.BatchData("Schedulers operation data", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            """ Per-object operation result """
            schema = api.Array(schemas.batch.BatchResult)


class ResourcesOp(Api.Path("/batch/resources/{operation}")):
    class Put(api.Put):
        """ Mass operation on resource objects """

        operation = api.Enum(
            "Operation type",
            values=["delete", "restore", "backup", "touch", "do_not_remove"],
            scope=api.Scope.PATH,
            required=True
        )
        data = schemas.batch.BatchData("Resources operation data", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            """ Per-object operation result """
            schema = api.Array(schemas.batch.BatchResult)


class ClientsOp(Api.Path("/batch/clients/{operation}")):
    class Put(api.Put):
        """ Mass operation on client objects """

        operation = api.Enum("Operation type", values=ctc.ReloadCommand, scope=api.Scope.PATH, required=True)
        data = schemas.batch.ClientsOpData("Clients operation data", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            """ Per-object operation result """
            schema = api.Array(schemas.batch.ClientOpResult)


class BucketsOp(Api.Path("/batch/buckets/{operation}")):
    class Put(api.Put):
        """ Mass operation on bucket resources """

        operation = api.Enum("Operation type", values=["cleanup"], scope=api.Scope.PATH, required=True)
        data = schemas.batch.BucketsOpData("Buckets operation data", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            """ Per-object operation result """
            schema = api.Array(schemas.batch.BucketOpResult)
