from __future__ import absolute_import

import functools as ft

from sandbox.common import api


class FilterBase(api.Get):
    # Pager block
    limit = api.Integer("Limit amount of records to return with the response", required=True)
    offset = api.Integer("Amount of records to skip in the result", default=0)
    order = api.Array(
        api.String,
        "Order specification by field name (prefix with '+' for ascending, '-' for descending)", default=[]
    )


class FilterBaseMultiOrder(api.Get):
    limit = api.Integer("Limit amount of records to return with the response", required=True)
    offset = api.Integer("Amount of records to skip in the result", default=0)
    order = api.Array(
        api.String,
        "Order specification by field name (prefix with '+' for ascending, '-' for descending). "
        "Supports multiple fields, separated by comma.", default=[]
    )


Ids = ft.partial(api.Array, api.Id)
